<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLeadsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name',100);
            $table->string('email',150);
            $table->string('phone',20);
            $table->text('message');
            $table->decimal('total_amount',10,2);
            $table->decimal('paid_amount',10,2);
            $table->string('payment_method',250);
            $table->string('client_type',150);
            $table->string('client_code',250);
            $table->string('status',100);
            $table->string('lead_type',200);
            $table->string('progress_status',100);
            $table->string('completion_date',200);
            $table->string('chat_ref',200);
            $table->string('chat_ref_detail',250);
            $table->integer('brand_id');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leads');
    }
}
