<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Page wrapper  -->
<!-- ============================================================== -->
<div class="page-wrapper">
    <!-- ============================================================== -->
    <!-- Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">Leads</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item">leads</li>
                <li class="breadcrumb-item active">Leads</li>
            </ol>
        </div>
        <div>

        </div>
    </div>
    <!-- ============================================================== -->
    <!-- End Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">
        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
        <div class="row">
            <div class="col-12">

                <div class="card">
                    <div class="card-body">

                        <button type="button" class="btn btn-info btn-circle" data-toggle="modal" data-target="#addleadModal" style="float:right;">
                            <i class="fa fa-plus"></i>
                        </button>

                        <h4 class="card-title">Leads</h4>
                        <h6 class="card-subtitle">leads</h6>

                        <div class="table-responsive m-t-40">
                            <table id="leadTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Message</th>
                                    <th>Status</th>
                                    <th>Brand Name</th>

                                </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $agentleads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($row->name); ?></td>
                                            <td><?php echo e($row->email); ?></td>
                                            <td><?php echo e($row->phone); ?></td>
                                            <td><?php echo e($row->message); ?></td>
                                            <td><span class="label label-table label-success"><?php echo e($row->status); ?></span></td>
                                            <td><?php echo e($row->brandname); ?></td>
                                            <td class="text-nowrap">
<!--                                                <a href="javascript:void(0)" class="btnSelect" data-toggle="tooltip" data-original-title="Edit" data-action="edit" data-rowid="<?php echo e($row->id); ?>"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>-->

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- ============================================================== -->
        <!-- End PAge Content -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Right sidebar -->
        <!-- ============================================================== -->
        <!-- .right-sidebar -->


        <!-- ============================================================== -->
        <!-- End Right sidebar -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->

<!-- Action Modal -->
<div class="modal fade" id="addleadModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Add Lead</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                <div class="container-fluid">

                    <form class="form-material m-t-40" method="POST" action="<?php echo e(route('add_leads')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control" name="name" value="" placeholder="Lead Name" required>
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" class="form-control" name="email" value="" placeholder="user@staffshaw.com" required>
                        </div>
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="number" class="form-control" name="number" value="" placeholder="03***" required>
                        </div>
                        <div class="form-group">
                            <label>Message</label>
                            <input type="text" class="form-control" name="message" value="" placeholder="--------" required>
                        </div>
                        <div class="form-group">
                            <label>Brands</label>
                            <select class="form-control brands" name="brands">

                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($rows->id); ?>"><?php echo e($rows->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>

                        <input type="hidden" name="id" value="<?php echo e(Session::get('id')); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex bd-highlight align-items-center">

                                    <div class="flex-grow-1 p-2 bd-highlight">
                                        <button type="submit" class="btn btn-primary form-control">Add Lead</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>
    </div>
</div>

    <!-- Edit Action Modal -->
    <div class="modal fade" id="editleadModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="exampleModalLongTitle">Edit Lead</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                    <div class="container-fluid">
                        <form class="form-material m-t-40" method="POST" action="<?php echo e(route('update_leads')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label>Name</label>
                                <input type="text" class="form-control name" name="name" value="" placeholder="name" required>
                            </div>
                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" class="form-control email" name="email" value="" placeholder="email" required>
                            </div>
                            <div class="form-group">
                                <label>Phone</label>
                                <input type="number" class="form-control number" name="number" value="" placeholder="03***" required>
                            </div>
                            <div class="form-group">
                                <label>Message</label>
                                <input type="text" class="form-control message" name="message" value="" placeholder="Message" required>
                            </div>
                            <div class="form-group">
                                <label>Status</label>
                                <select class="form-control status" name="status">
                                    <option value="assigned">assigned</option>
                                    <option value="unassigned">unassigned</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Brand Name</label>
                                <input type="text" class="form-control brandname" name="brandname" value="" placeholder="Brand Name" required>
                            </div>
                            <div class="form-group">
                                <label>Agents</label>
                                <select class="form-control agents" name="agents">

                                    <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($rows->id); ?>"><?php echo e($rows->first_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>

                            <input type="hidden" name="id" value="<?php echo e(Session::get('id')); ?>">
                            <input type="hidden" name="editleadid" value="" class="editleadid">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="d-flex bd-highlight align-items-center">

                                        <div class="flex-grow-1 p-2 bd-highlight">
                                            <button type="submit" class="btn btn-primary form-control">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <!-- Delete Action Modal-->
    <div id="deleteleadModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-confirm modal-dialog-centered">
            <div class="modal-content">
                <!-- <div class="modal-header">

                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div> -->
                <div class="modal-body" align="center">
                    <img src="<?php echo e(asset('public/assets/images/close.png')); ?>" width="70" height="70">
                    <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                    <p style="color: #999999">Do you really want to delete this records?</p>
                    <form method="POST" action="<?php echo e(route('delete_leads')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="deleteleadid" class="deleteleadid" id="deleteleadblastid">
                        <button type="submit" class="btn btn-danger">Delete</button>
                        <button type="button" class="btn btn-info" data-dismiss="modal">Cancel</button>
                    </form>
                </div>
                <!-- <div class="modal-footer" align="center">

                </div> -->
            </div>
        </div>
    </div>

    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">

        $(document).ready(function(){

            // code to read selected table row cell data (values).
            $("#leadTable").on('click','.btnSelect',function(){

                    var action = $(this).data('action');
                    var rowid = $(this).data('rowid');

                    if(action == 'edit'){

                        // get the current row
                        var currentRow = $(this).closest("tr");

                        var name = currentRow.find("td:eq(0)").text();
                        var email = currentRow.find("td:eq(1)").text();
                        var phone = currentRow.find("td:eq(2)").text();
                        var message = currentRow.find("td:eq(3)").text();
                        var status = currentRow.find("td:eq(4)").text();
                        var brandname = currentRow.find("td:eq(5)").text();

                        $('.name').val(name);
                        $('.email').val(email);
                        $('.number').val(phone);
                        $('.message').val(message);
                        $('.status').val(status);
                        $('.brandname').val(brandname);
                        $('.editleadid').val(rowid);

                        $('#editleadModal').modal('show');
                    }
                    else{
                        $('.deleteleadid').val(rowid);
                        $('#deleteleadModal').modal('show');
                    }

                }

            );
        });

    </script>
<?php /**PATH D:\xampp\htdocs\staffshaw_crm\resources\views/pages/agentleads.blade.php ENDPATH**/ ?>