<?php

namespace App\Http\Controllers\Crm;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Mail;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        if ($request->session()->get('id') != null) {

            if(session()->get('usertype') == 1){
                $total_managers = DB::table('users')
                    ->select()
                    ->where('usertype_id', 3)
                    ->count('*');
                $total_agents = DB::table('users')
                    ->select()
                    ->where('usertype_id', 2)
                    ->count('*');
                $total_brands = DB::table('brands')
                    ->select()
                    ->count('*');
                $total_leads = DB::table('leads')
                    ->select()
                    ->count('*');
                $total_content_orders = DB::table('content_order')
                                            ->select()
                                            ->count('*');
                $total_design_orders = DB::table('design_order')
                                            ->select()
                                            ->count('*');
                $total_amount = DB::table('leads')->select()->sum('leads.converted_total_amount');
                $total_paid_amount = DB::table('leads')->select()->sum('leads.converted_paid_amount');
                

                return view('pages.index', compact('total_managers','total_agents','total_brands','total_leads','total_content_orders','total_design_orders','total_amount','total_paid_amount'));
            }elseif(session()->get('usertype') == 3){
                if(session()->get('department_id') == 1 || session()->get('department_id') == 2 || session()->get('department_id') == 3){
                    $total_agents = DB::table('users')
                        ->select()
                        ->where('parent_user_id', session()->get('id'))
                        ->count('*');
                    $total_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->count('*');
                    $assign_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->get();
                    $total_leads = 0;
                    $total_content_orders = 0;
                    $total_design_orders = 0;
                    if(!empty($assign_brands)){
                        foreach ($assign_brands as $row) {
                            $lead_count = DB::table('leads')->where('brand_id',$row->brand_id)->count('*');
                            $total_leads += $lead_count;
                            $content_lead_count = DB::table('content_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_content_orders += $content_lead_count;
                            $design_lead_count = DB::table('design_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_design_orders += $design_lead_count;
                        }
                    }
                    
                    return view('pages.index', compact('total_agents','total_brands','total_leads','total_content_orders','total_design_orders'));
                }elseif(session()->get('department_id') == 5){
                    
                    $logo_sd_count = 0;
                    $website_sd_count = 0;
                    $stationary_sd_count = 0;
                    $social_media_sd_count = 0;
                    
                    $leads = DB::table('leads')->where(['leads.progress_status' => 'Completed'])->get();
                    foreach($leads as $row){
                        $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                        
                        if(!empty($get_lead__logo_order)){
                            $logo_sd_count++;
                        }
                        
                        if(!empty($get_lead__website_order)){
                            $website_sd_count++;
                        } 
                        
                        if(!empty($get_lead__stationary_order)){
                            $stationary_sd_count++;
                        } 
                        if(!empty($get_lead__social_media_order)){
                            $social_media_sd_count++;
                        } 
                    }
                    
                    $total_agents = DB::table('users')
                                        ->select()
                                        ->where('parent_user_id', session()->get('id'))
                                        ->count('*');
                    $total_leads = DB::table('leads')
                                ->where('progress_status', 'Completed')
                                ->count('*');
                    $total_production_complete = DB::table('leads')
                                                ->where('production_status', 'Completed')
                                                ->count('*');
                    $total_production_notstarted = DB::table('leads')
                                                ->where('progress_status', 'Completed')
                                                ->where('production_status', 'Not started')
                                                ->count('*');
                    $total_production_inprogress = DB::table('leads')
                                                ->where('progress_status', 'Completed')
                                                ->where('production_status', 'In Progress')
                                                ->count('*');
                                                
                    $total_production_cancel = DB::table('leads')
                                                ->where('progress_status', 'Completed')
                                                ->where('production_status', 'Canceled')
                                                ->count('*');
                                
                    return view('pages.index', compact('total_agents','total_leads','total_production_complete','total_production_notstarted','total_production_inprogress','total_production_cancel','logo_sd_count','website_sd_count','stationary_sd_count','social_media_sd_count'));
                }elseif(session()->get('department_id') == 8){
                    
                    $assign_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->get();
                    $logo_sd_count = 0;
                    $website_sd_count = 0;
                    $stationary_sd_count = 0;
                    $social_media_sd_count = 0;
                    
                    if(!empty($assign_brands)){
                        foreach ($assign_brands as $user_brands) {
                            
                            $leads = DB::table('leads')->where(['leads.progress_status' => 'Completed','brand_id' => $user_brands->brand_id])->get();
                            foreach($leads as $row){
                                $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                
                                if(!empty($get_lead__logo_order)){
                                    $logo_sd_count++;
                                }
                                
                                if(!empty($get_lead__website_order)){
                                    $website_sd_count++;
                                } 
                                
                                if(!empty($get_lead__stationary_order)){
                                    $stationary_sd_count++;
                                } 
                                if(!empty($get_lead__social_media_order)){
                                    $social_media_sd_count++;
                                } 
                            }
                        }
                    }
                    
                    $universal_sd_count = $logo_sd_count + $website_sd_count + $stationary_sd_count + $social_media_sd_count;
                                
                    return view('pages.index', compact('logo_sd_count','website_sd_count','stationary_sd_count','social_media_sd_count','universal_sd_count'));
                }
            }elseif(session()->get('usertype') == 2){
                if(session()->get('department_id') == 1 || session()->get('department_id') == 2 || session()->get('department_id') == 3){
                    $total_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->count('*');
                    $assign_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->get();
                    $total_leads = 0;
                    $total_content_orders = 0;
                    $total_design_orders = 0;
                    if(!empty($assign_brands)){
                        foreach ($assign_brands as $row) {
                            $lead_count = DB::table('leads')->where('brand_id',$row->brand_id)->count('*');
                            $total_leads += $lead_count;
                            $content_lead_count = DB::table('content_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_content_orders += $content_lead_count;
                            $design_lead_count = DB::table('design_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_design_orders += $design_lead_count;
                        }
                    }
                    return view('pages.index', compact('total_brands','total_leads','total_content_orders','total_design_orders'));
                }elseif(session()->get('department_id') == 5){
                    $total_agents = DB::table('users')
                        ->select()
                        ->where('parent_user_id', session()->get('id'))
                        ->count('*');
                    $total_leads = DB::table('production_task_assigning')->where('user_id', session()->get('id'))->count('*');
                    return view('pages.index', compact('total_leads', 'total_agents'));
                }elseif(session()->get('department_id') == 8){
                    
                    $assign_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->get();
                    $logo_sd_count = 0;
                    $website_sd_count = 0;
                    $stationary_sd_count = 0;
                    $social_media_sd_count = 0;
                    
                    if(!empty($assign_brands)){
                        foreach ($assign_brands as $user_brands) {
                            
                            $leads = DB::table('leads')->where(['leads.progress_status' => 'Completed','brand_id' => $user_brands->brand_id])->get();
                            foreach($leads as $row){
                                $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                
                                if(!empty($get_lead__logo_order)){
                                    $logo_sd_count++;
                                }
                                
                                if(!empty($get_lead__website_order)){
                                    $website_sd_count++;
                                }
                                
                                if(!empty($get_lead__stationary_order)){
                                    $stationary_sd_count++;
                                } 
                                if(!empty($get_lead__social_media_order)){
                                    $social_media_sd_count++;
                                } 
                            }
                        }
                    }
                                
                    return view('pages.index', compact('logo_sd_count','website_sd_count','stationary_sd_count','social_media_sd_count'));
                }
            }
            elseif(session()->get('usertype') == 4){
                if(session()->get('department_id') == 1 || session()->get('department_id') == 2 || session()->get('department_id') == 3 || session()->get('department_id') == 8){
                    $total_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->count('*');
                    $assign_brands = DB::table('brand_assign')->where('assign_user_id',session()->get('id'))->get();
                    $total_leads = 0;
                    $total_content_orders = 0;
                    $total_design_orders = 0;
                    if(!empty($assign_brands)){
                        foreach ($assign_brands as $row) {
                            $lead_count = DB::table('leads')->where('brand_id',$row->brand_id)->count('*');
                            $total_leads += $lead_count;
                            $content_lead_count = DB::table('content_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_content_orders += $content_lead_count;
                            $design_lead_count = DB::table('design_order')->where('brand_id',$row->brand_id)->count('*');
                            $total_design_orders += $design_lead_count;
                        }
                    }
                    return view('pages.index', compact('total_brands','total_leads','total_content_orders','total_design_orders'));
                }elseif(session()->get('department_id') == 5){
                    $total_leads = DB::table('production_task_assigning')->where('user_id', session()->get('id'))->count('*');
                    return view('pages.index', compact('total_leads'));
                }
            }

        } else {

            return redirect()->route('login');
        }
    }

    public function goBack()
    {
        return redirect(\URL::previous());
    }
    
    // Roles
    public function roles(){
        $roles = DB::table('usertype')->get();
        return view('pages.roles',compact('roles'));
    }
    
    // Roles Edit
    public function rolesEdit(Request $request){
        $data = [
            'name' => $request->name    
        ];
        $update = DB::table('usertype')->where('id', $request->roleid)->update($data);
        if($update){
            toastr()->success("Roles updated successfully");
            return redirect()->back();
        }else{
            toastr()->error("Something went wrong");
            return redirect()->back();
        }
    }
}
