<?php

namespace App\Http\Controllers\Crm\Leads;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class LeadsController extends Controller
{

    //assignlead
    public function index(Request $request)
    {
        if ($request->session()->get('id') != null) {

            if(session()->get('usertype') == 1){
                $leads = DB::table('leads')
                    ->select('leads.*','brands.name as brandname')
                    ->join('brands','brands.id','leads.brand_id')
                    ->where('status', 'assigned')
                    ->orderby('updated_at', 'desc')
                    ->get();


                $agents = DB::table('users')
                    ->select('*')
                    ->where('usertype_id',2)
                    ->orderby('updated_at', 'desc')
                    ->get();
                return view('pages.leads',compact('leads','agents'));
            }
            else{
                $agentleads = DB::table('leads')
                    ->select('leads.*','assign_leads.lead_id','assign_leads.agent_id','brands.name as brandname')
                    ->join('brands','brands.id','leads.brand_id')
                    ->join('assign_leads','assign_leads.lead_id','leads.id')
                    ->where('leads.status', 'assigned')
                    ->where('assign_leads.agent_id', $request->session()->get('id'))
                    ->orderby('updated_at', 'desc')
                    ->paginate(20);

                $agents = DB::table('users')
                    ->select('*')
                    ->where('usertype_id',2)
                    ->orderby('updated_at', 'desc')
                    ->paginate(20);

                $brands = DB::table('brands')
                    ->select('*')
                    ->orderby('updated_at', 'desc')
                    ->paginate(20);

                return view('pages.agentleads',compact('agentleads','agents', 'brands'));
            }

        } else {

            return redirect()->route('login');
        }
    }

    //unassign lead
    public function unassignlead(Request $request, $type = null,  $sdtype = null)
    {
        
        // $ip = \Request::getClientIp(true);
        // dd($ip);
        // $data = \Location::get($ip);
        // dd($data);
        
        if ($request->session()->get('id') != null) {
            $leads = [];
            if(session()->get('usertype') == 1){

                $le = DB::table('leads')
                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                    ->leftjoin('brands','brands.id','leads.brand_id')
                    ->leftjoin('users','users.id','leads.user_id')
                    ->orderby('leads.id', 'desc')
                    ->get();
                // dd($le);
                if(!empty($le)){
                    foreach($le as $row){
                        $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                        $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__general_content_order = DB::table('general_content_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__thesis_order = DB::table('thesis_questionnaire')->where(['lead_id' => $row->id])->first();
                        
                        // if(!empty($check_upsale_lead)){
                            $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                            $data = [
                                'id' => $row->id,
                                'name' => $row->name,
                                'email' => $row->email,
                                'phone' => $row->phone,
                                'message' => $row->message,
                                'total_amount' => $row->total_amount,
                                'paid_amount' => $row->paid_amount,
                                'currency' => $row->currency,
                                'payment_method' => $row->payment_method,
                                'client_type' => $row->client_type,
                                'client_code' => $row->client_code,
                                'status' => $row->status,
                                'lead_type' => $row->lead_type,
                                'progress_status' => $row->progress_status,
                                'production_status' => $row->production_status,
                                'support_status' => $row->support_status,
                                'completion_date' => $row->completion_date,
                                'chat_ref' => $row->chat_ref,
                                'chat_ref_detail' => $row->chat_ref_detail,
                                'brand_id' => $row->brand_id,
                                'user_id' => $row->user_id,
                                'created_at' => $row->created_at,
                                'updated_at' => $row->updated_at,
                                'brandname' => $row->brandname,
                                'brandurl' => $row->brandurl,
                                'brandtype' => $row->brandtype,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'image' => $row->image,
                                'attachment' => $row->attachment,
                                'upsale' => $check_upsale_lead ?? null,
                                'assigned_by' => $row->assigned_by,
                                'production_user' => $get_production ?? null,
                                'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                'lead_website_order_id' => $get_lead__website_order ?? null,
                                'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                'lead_content_order_id' => $get_lead__content_order ?? null,
                                'lead_general_content_order_id' => $get_lead__general_content_order ?? null,
                                'lead_thesis_order_id' => $get_lead__thesis_order ?? null,
                            ]; 
                        // }
                        // else{
                        //     $get_production = DB::table('production_task_assigning')
                        //                                 ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                        //                                 ->leftjoin('users','users.id','production_task_assigning.user_id')
                        //                                 ->where('lead_id', $row->id)->get();
                        //     $data = [
                        //         'id' => $row->id,
                        //         'name' => $row->name,
                        //         'email' => $row->email,
                        //         'phone' => $row->phone,
                        //         'message' => $row->message,
                        //         'total_amount' => $row->total_amount,
                        //         'paid_amount' => $row->paid_amount,
                        //         'currency' => $row->currency,
                        //         'payment_method' => $row->payment_method,
                        //         'client_type' => $row->client_type,
                        //         'client_code' => $row->client_code,
                        //         'status' => $row->status,
                        //         'lead_type' => $row->lead_type,
                        //         'progress_status' => $row->progress_status,
                        //         'production_status' => $row->production_status,
                        //         'support_status' => $row->support_status,
                        //         'completion_date' => $row->completion_date,
                        //         'chat_ref' => $row->chat_ref,
                        //         'chat_ref_detail' => $row->chat_ref_detail,
                        //         'brand_id' => $row->brand_id,
                        //         'user_id' => $row->user_id,
                        //         'created_at' => $row->created_at,
                        //         'updated_at' => $row->updated_at,
                        //         'brandname' => $row->brandname,
                        //         'brandurl' => $row->brandurl,
                        //         'first_name' => $row->first_name,
                        //         'last_name' => $row->last_name,
                        //         'image' => $row->image,
                        //         'attachment' => $row->attachment,
                        //         'upsale' => null,
                        //         'assigned_by' => $row->assigned_by,
                        //         'lead_logo_order_id' => $get_lead__logo_order ?? null,
                        //         'lead_website_order_id' => $get_lead__website_order ?? null,
                        //         'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                        //         'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                        //     ];
                        // }
                        
                        array_push($leads, $data);
                    }
                }
                $agents = DB::table('users')
                                ->get();
                // $agents = DB::table('users')
                //                 ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                //                 ->leftjoin('usertype','usertype.id','users.usertype_id')
                //                 ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                //                 ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                //                 ->get();
                
                
                $brands = DB::table('brands')->get();
                // dd($leads);
                return view('pages.leads',compact('leads','brands','agents'));
            }
            elseif(session()->get('usertype') == 3 || session()->get('usertype') == 2  || session()->get('usertype') == 4){
                
                if(session()->get('department_id') == 5 || session()->get('department_id') == 8){ // For Production Condition & Support
                    if(session()->get('usertype') == 3){
                        $brands = DB::table('brands')
                                ->get();    
                    }else{
                        $brands = DB::table('production_task_assigning')
                                ->where('user_id', session()->get('id'))
                                ->get();
                    }
                }
                else{
                    $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();    
                }
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        
                        if(session()->get('department_id') == 5){ // For Production Condition & Support
                            if(session()->get('usertype') == 3){
                                if($type != null && $type != "all"){
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => $type, 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }else{
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }
                                
                            }else{
                                if($type != null && $type != "all"){
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.production_status' => $type, 'leads.id' => $row->lead_id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }else{
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where('leads.id',$row->lead_id)
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }
                            }
                            
                            
                        }elseif( session()->get('department_id') == 8){
                            if(session()->get('usertype') == 3){
                                $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Welcome', 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                            }else{
                                $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where('leads.id',$row->lead_id)
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                            }
                        }
                        else{
                            // dd("check");
                            $le = DB::table('leads')
                            ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','brands.type as brandtype','users.first_name','users.last_name','users.image')
                            ->leftjoin('brands','brands.id','leads.brand_id')
                            ->leftjoin('users','users.id','leads.user_id')
                            ->where('leads.brand_id',$row->brand_id)
                            ->orderby('updated_at', 'desc')
                            ->get();    
                        }
                        
                       
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                if($sdtype == null){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__general_content_order = DB::table('general_content_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__thesis_order = DB::table('thesis_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($sdtype == "logo"){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($sdtype == "website"){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($sdtype == "stationary"){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($sdtype == "social-media"){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($sdtype == "design-content"){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                
                                if(session()->get('department_id') == 5 || session()->get('department_id') == 8){
                                    if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) ){
                                        $get_production = DB::table('production_task_assigning')
                                                            ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                            ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                            ->where('lead_id', $row->id)->get();
                                        $data = [
                                            'id' => $row->id,
                                            'name' => $row->name,
                                            'email' => $row->email,
                                            'phone' => $row->phone,
                                            'message' => $row->message,
                                            'total_amount' => $row->total_amount,
                                            'paid_amount' => $row->paid_amount,
                                            'currency' => $row->currency,
                                            'payment_method' => $row->payment_method,
                                            'client_type' => $row->client_type,
                                            'client_code' => $row->client_code,
                                            'status' => $row->status,
                                            'lead_type' => $row->lead_type,
                                            'progress_status' => $row->progress_status,
                                            'production_status' => $row->production_status,
                                            'support_status' => $row->support_status,
                                            'completion_date' => $row->completion_date,
                                            'chat_ref' => $row->chat_ref,
                                            'chat_ref_detail' => $row->chat_ref_detail,
                                            'brand_id' => $row->brand_id,
                                            'user_id' => $row->user_id,
                                            'created_at' => $row->created_at,
                                            'updated_at' => $row->updated_at,
                                            'brandname' => $row->brandname,
                                            'brandurl' => $row->brandurl,
                                            'brandtype' => $row->brandtype,
                                            'first_name' => $row->first_name,
                                            'last_name' => $row->last_name,
                                            'image' => $row->image,
                                            'attachment' => $row->attachment,
                                            'upsale' => $check_upsale_lead ?? null,
                                            'assigned_by' => $row->assigned_by,
                                            'production_user' => $get_production ?? null,
                                            'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                            'lead_website_order_id' => $get_lead__website_order ?? null,
                                            'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                            'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                            'lead_content_order_id' => $get_lead__content_order ?? null,
                                            'lead_general_content_order_id' => $get_lead__general_content_order ?? null,
                                            'lead_thesis_order_id' => $get_lead__thesis_order ?? null,
                                        ];
                                    
                                        array_push($leads, $data);
                                    }
                                }else{
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'brandtype' => $row->brandtype,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead ?? null,
                                        'assigned_by' => $row->assigned_by,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                        'lead_general_content_order_id' => $get_lead__general_content_order ?? null,
                                        'lead_thesis_order_id' => $get_lead__thesis_order ?? null,
                                    ];
                                
                                    array_push($leads, $data);
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                // dd($leads);
                //  echo '<pre>';
                // print_r($leads);
                // echo '</pre>';die();
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2 || session()->get('usertype') == 4){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    // dd("check");
                    if(session()->get('department_id') == 5){
                        if(session()->get('usertype') == 3){
                            
                            $agent_by_depart = DB::table('department_assign')
                                                ->select('department_assign.department_id', 'department_assign.user_id', 'users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                                ->leftjoin('users','department_assign.user_id','users.id')
                                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                                ->where('users.usertype_id', 4)
                                                ->get();
                                                
                            $get_total_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed'])
                                                    ->count();
                            $get_not_started_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Not Started'])
                                                    ->count();
                            $get_in_progress_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'In Progress'])
                                                    ->count();
                            $get_completed_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Completed'])
                                                    ->count();
                            $get_deferred_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Deferred'])
                                                    ->count();
                            $get_cancelled_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Cancelled'])
                                                    ->count();
                                    
                            // dd($leads);
                            return view('pages.leads',compact('leads','brands','agents', 'agent_by_depart','get_total_count','get_not_started_count','get_in_progress_count','get_completed_count','get_deferred_count','get_cancelled_count'));
                        }
                        else{
                            // dd("check");
                            $get_total_count = DB::table('production_task_assigning')
                                                ->select('*','leads.progress_status','leads.production_status')
                                                ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                ->where(
                                                    [
                                                        'production_task_assigning.user_id' => session()->get('id'),
                                                        'leads.progress_status' => 'Completed',
                                                        // 'leads.production_status' => 'Not Started'
                                                    ])
                                                ->count();
                                                
                            $get_not_started_count = DB::table('production_task_assigning')
                                                        ->select('*','leads.progress_status','leads.production_status')
                                                        ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                        ->where(
                                                            [
                                                                'production_task_assigning.user_id' => session()->get('id'),
                                                                'leads.progress_status' => 'Completed',
                                                                'leads.production_status' => 'Not Started'
                                                            ])
                                                        ->count();
                            $get_in_progress_count = DB::table('production_task_assigning')
                                                        ->select('*','leads.progress_status','leads.production_status')
                                                        ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                        ->where(
                                                            [
                                                                'production_task_assigning.user_id' => session()->get('id'),
                                                                'leads.progress_status' => 'Completed',
                                                                'leads.production_status' => 'In Progress'
                                                            ])
                                                        ->count();
                            
                            
                            $get_completed_count = DB::table('production_task_assigning')
                                                        ->select('*','leads.progress_status','leads.production_status')
                                                        ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                        ->where(
                                                            [
                                                                'production_task_assigning.user_id' => session()->get('id'),
                                                                'leads.progress_status' => 'Completed',
                                                                'leads.production_status' => 'Completed'
                                                            ])
                                                        ->count();
                                                        
                            $get_deferred_count = DB::table('production_task_assigning')
                                                        ->select('*','leads.progress_status','leads.production_status')
                                                        ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                        ->where(
                                                            [
                                                                'production_task_assigning.user_id' => session()->get('id'),
                                                                'leads.progress_status' => 'Completed',
                                                                'leads.production_status' => 'Deferred'
                                                            ])
                                                        ->count();
                            
                            
                            $get_cancelled_count = DB::table('production_task_assigning')
                                                        ->select('*','leads.progress_status','leads.production_status')
                                                        ->leftjoin('leads','leads.id', 'production_task_assigning.lead_id')
                                                        ->where(
                                                            [
                                                                'production_task_assigning.user_id' => session()->get('id'),
                                                                'leads.progress_status' => 'Completed',
                                                                'leads.production_status' => 'Cancelled'
                                                            ])
                                                        ->count();
                            
                            
                         return view('pages.leads',compact('leads','brands','agents','get_total_count','get_not_started_count','get_in_progress_count','get_completed_count','get_deferred_count','get_cancelled_count'));
                        }
                    }
                    return view('pages.leads',compact('leads','brands','agents'));
                }
                else{
                    return view('pages.leads',compact('leads','brands'));
                }
                
            }

        } else {

            return redirect()->route('login');
        }
    }

    // Completed leads From sales side
    public function completedLeads(Request $request, $type = null){
        
        if ($request->session()->get('id') != null) {
            $leads = [];
            if(session()->get('usertype') == 1){

                $le = DB::table('leads')
                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                    ->leftjoin('brands','brands.id','leads.brand_id')
                    ->leftjoin('users','users.id','leads.user_id')
                    ->where('leads.progress_status','Completed')
                    ->orderby('leads.id', 'desc')
                    ->get();
                // dd($le);
                if(!empty($le)){
                    foreach($le as $row){
                        $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                        $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                        $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                        $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                        
                        if(!empty($check_upsale_lead)){
                            $data = [
                                'id' => $row->id,
                                'name' => $row->name,
                                'email' => $row->email,
                                'phone' => $row->phone,
                                'message' => $row->message,
                                'total_amount' => $row->total_amount,
                                'paid_amount' => $row->paid_amount,
                                'currency' => $row->currency,
                                'payment_method' => $row->payment_method,
                                'client_type' => $row->client_type,
                                'client_code' => $row->client_code,
                                'status' => $row->status,
                                'lead_type' => $row->lead_type,
                                'progress_status' => $row->progress_status,
                                'production_status' => $row->production_status,
                                'support_status' => $row->support_status,
                                'completion_date' => $row->completion_date,
                                'chat_ref' => $row->chat_ref,
                                'chat_ref_detail' => $row->chat_ref_detail,
                                'brand_id' => $row->brand_id,
                                'user_id' => $row->user_id,
                                'created_at' => $row->created_at,
                                'updated_at' => $row->updated_at,
                                'brandname' => $row->brandname,
                                'brandurl' => $row->brandurl,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'image' => $row->image,
                                'attachment' => $row->attachment,
                                'upsale' => $check_upsale_lead,
                                'assigned_by' => $row->assigned_by,
                                'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                'lead_website_order_id' => $get_lead__website_order ?? null,
                                'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                'lead_content_order_id' => $get_lead__content_order ?? null,
                            ]; 
                        }
                        else{
                            $data = [
                                'id' => $row->id,
                                'name' => $row->name,
                                'email' => $row->email,
                                'phone' => $row->phone,
                                'message' => $row->message,
                                'total_amount' => $row->total_amount,
                                'paid_amount' => $row->paid_amount,
                                'currency' => $row->currency,
                                'payment_method' => $row->payment_method,
                                'client_type' => $row->client_type,
                                'client_code' => $row->client_code,
                                'status' => $row->status,
                                'lead_type' => $row->lead_type,
                                'progress_status' => $row->progress_status,
                                'production_status' => $row->production_status,
                                'support_status' => $row->support_status,
                                'completion_date' => $row->completion_date,
                                'chat_ref' => $row->chat_ref,
                                'chat_ref_detail' => $row->chat_ref_detail,
                                'brand_id' => $row->brand_id,
                                'user_id' => $row->user_id,
                                'created_at' => $row->created_at,
                                'updated_at' => $row->updated_at,
                                'brandname' => $row->brandname,
                                'brandurl' => $row->brandurl,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'image' => $row->image,
                                'attachment' => $row->attachment,
                                'upsale' => null,
                                'assigned_by' => $row->assigned_by,
                                'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                'lead_website_order_id' => $get_lead__website_order ?? null,
                                'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                'lead_content_order_id' => $get_lead__content_order ?? null,
                            ];
                        }
                        
                        array_push($leads, $data);
                    }
                }
                $agents = DB::table('users')
                                ->get();
                // $agents = DB::table('users')
                //                 ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                //                 ->leftjoin('usertype','usertype.id','users.usertype_id')
                //                 ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                //                 ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                //                 ->get();
                
                
                $brands = DB::table('brands')->get();
         
                return view('pages.leads',compact('leads','brands','agents'));
            }
            elseif(session()->get('usertype') == 3 || session()->get('usertype') == 2  || session()->get('usertype') == 4){
                
                if(session()->get('department_id') == 5 || session()->get('department_id') == 8){ // For Production Condition & Support
                    if(session()->get('usertype') == 3){
                        $brands = DB::table('brands')
                                ->get();    
                    }else{
                        $brands = DB::table('production_task_assigning')
                                ->where('user_id', session()->get('id'))
                                ->get();
                    }
                }
                else{
                    $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();    
                }
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        
                        if(session()->get('department_id') == 5){ // For Production Condition & Support
                            if(session()->get('usertype') == 3){
                                if($type != null && $type != "all"){
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => $type, 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }else{
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }
                                
                            }else{
                                if($type != null && $type != "all"){
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.production_status' => $type, 'leads.id' => $row->lead_id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }else{
                                    $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where('leads.id',$row->lead_id)
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                }
                            }
                            
                            
                        }elseif( session()->get('department_id') == 8){
                            if(session()->get('usertype') == 3){
                                $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Welcome', 'leads.brand_id'=> $row->id])
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                            }else{
                                $le = DB::table('leads')
                                    ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','leads.brand_id')
                                    ->leftjoin('users','users.id','leads.user_id')
                                    ->where('leads.id',$row->lead_id)
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                            }
                        }
                        else{
                            $le = DB::table('leads')
                            ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                            ->leftjoin('brands','brands.id','leads.brand_id')
                            ->leftjoin('users','users.id','leads.user_id')
                            ->where('leads.brand_id',$row->brand_id)
                            ->orderby('updated_at', 'desc')
                            ->get();    
                        }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                
                                if(!empty($check_upsale_lead)){
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'assigned_by' => $row->assigned_by,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                }
                                else{
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => null,
                                        'assigned_by' => $row->assigned_by,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                }
                                array_push($leads, $data);
                            }
                        }
                    }
                }
                rsort($leads);
                // dd($leads);
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    if(session()->get('department_id') == 5){
                        if(session()->get('usertype') == 3){
                            $agent_by_depart = DB::table('department_assign')
                                                ->select('department_assign.department_id', 'department_assign.user_id', 'users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                                ->leftjoin('users','department_assign.user_id','users.id')
                                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                                ->where('users.usertype_id', 4)
                                                ->get();
                                                
                            $get_total_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed'])
                                                    ->count();
                            $get_not_started_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Not Started'])
                                                    ->count();
                            $get_in_progress_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'In Progress'])
                                                    ->count();
                            $get_completed_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Completed'])
                                                    ->count();
                            $get_deferred_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Deferred'])
                                                    ->count();
                            $get_cancelled_count = DB::table('leads')
                                                    ->select('*')
                                                    ->where(['leads.progress_status' => 'Completed','leads.production_status' => 'Cancelled'])
                                                    ->count();
                                    
                                    
                            return view('pages.leads',compact('leads','brands','agents', 'agent_by_depart','get_total_count','get_not_started_count','get_in_progress_count','get_completed_count','get_deferred_count','get_cancelled_count'));
                        }
                    }
                    return view('pages.leads',compact('leads','brands','agents'));
                }
                else{
                    return view('pages.leads',compact('leads','brands'));
                }
                
            }

        } else {

            return redirect()->route('login');
        }
    }


    // User Leads 
    public function userLead(){
        if (session()->get('id') != null) {

            $leads = [];
            if(session()->get('usertype') == 1){

                $le = DB::table('leads')
                    ->select('leads.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                    ->leftjoin('brands','brands.id','leads.brand_id')
                    ->leftjoin('users','users.id','leads.user_id')
                    ->where('leads.user_id', session()->get('id'))
                    // ->orderby('updated_at', 'asc')
                    ->get();
                    
                if(!empty($le)){
                    foreach($le as $row){
                        $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                        if(!empty($check_upsale_lead)){
                            $data = [
                                'id' => $row->id,
                                'name' => $row->name,
                                'email' => $row->email,
                                'phone' => $row->phone,
                                'message' => $row->message,
                                'total_amount' => $row->total_amount,
                                'paid_amount' => $row->paid_amount,
                                'currency' => $row->currency,
                                'payment_method' => $row->payment_method,
                                'client_type' => $row->client_type,
                                'client_code' => $row->client_code,
                                'status' => $row->status,
                                'lead_type' => $row->lead_type,
                                'progress_status' => $row->progress_status,
                                'completion_date' => $row->completion_date,
                                'chat_ref' => $row->chat_ref,
                                'chat_ref_detail' => $row->chat_ref_detail,
                                'brand_id' => $row->brand_id,
                                'user_id' => $row->user_id,
                                'created_at' => $row->created_at,
                                'updated_at' => $row->updated_at,
                                'brandname' => $row->brandname,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'image' => $row->image,
                                'attachment' => $row->attachment,
                                'upsale' => $check_upsale_lead,
                            ];
                        }
                        else{
                            $data = [
                                'id' => $row->id,
                                'name' => $row->name,
                                'email' => $row->email,
                                'phone' => $row->phone,
                                'message' => $row->message,
                                'total_amount' => $row->total_amount,
                                'paid_amount' => $row->paid_amount,
                                'currency' => $row->currency,
                                'payment_method' => $row->payment_method,
                                'client_type' => $row->client_type,
                                'client_code' => $row->client_code,
                                'status' => $row->status,
                                'lead_type' => $row->lead_type,
                                'progress_status' => $row->progress_status,
                                'completion_date' => $row->completion_date,
                                'chat_ref' => $row->chat_ref,
                                'chat_ref_detail' => $row->chat_ref_detail,
                                'brand_id' => $row->brand_id,
                                'user_id' => $row->user_id,
                                'created_at' => $row->created_at,
                                'updated_at' => $row->updated_at,
                                'brandname' => $row->brandname,
                                'first_name' => $row->first_name,
                                'last_name' => $row->last_name,
                                'image' => $row->image,
                                'attachment' => $row->attachment,
                                'upsale' => null,
                            ];
                        }
                        
                        array_push($leads, $data);
                    }
                }

                $brands = DB::table('brands')->get();
                return view('pages.agentleads',compact('leads','brands'));
            }
            elseif(session()->get('usertype') == 3 || session()->get('usertype') == 2 || session()->get('usertype') == 4){
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                // if(!empty($brands)){
                //     foreach($brands as $row){
                        $le = DB::table('leads')
                            ->select('leads.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                            ->leftjoin('brands','brands.id','leads.brand_id')
                            ->leftjoin('users','users.id','leads.user_id')
                            ->where('leads.user_id',session()->get('id'))
                            ->orderby('updated_at', 'desc')
                            ->get();
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                if(!empty($check_upsale_lead)){
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                    ];
                                }
                                else{
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => null,
                                    ];
                                }
                                array_push($leads, $data);
                            }
                    //     }
                    // }
                }

                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    return view('pages.agentleads',compact('leads','brands','agents'));
                }
                else{
                    return view('pages.agentleads',compact('leads','brands'));
                }     
            }

        }else {

            return redirect()->route('login');
        }
    }

    //add lead
    public function addlead(Request $request){
        // dd($request);
        $validate = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            // 'total_amount' => 'required',
            // 'paid_amount' => 'required',
            'brand' => 'required',
            // 'progress_status' => 'required',
            // 'lead_status' => 'required',
            // 'cod' => 'required',
            // 'payment_method' => 'required',
            // 'client_type' => 'required',
            // 'chat_ref' => 'required',
            // 'client_code' => 'required',
            // 'chat_ref_detail' => 'required',
            'client_message' => 'required',
        ]);

        $json = json_decode(file_get_contents('https://openexchangerates.org/api/latest.json?app_id=96cb7e699fb840ebbfb1d682e1304b31&base=USD'), true);
        $currency_amount = array_column($json, $request->curreny ?? 'USD');
        $dollar_total_amount = $request->total_amount ?? 0 / $currency_amount[0];
        $dollar_paid_amount = $request->paid_amount ?? 0 / $currency_amount[0];
        $attachment = "";
        $comma_file = null;
        if($request->hasFile('add_lead_attachment')){
            // $file = $request->file('add_lead_attachment');
            // $attachment = uniqid().'.'.$file->guessExtension();
            // $attachment_path = $file->move(public_path().'/backend/media/attachments/',$attachment);
            
            $file = $request->file('add_lead_attachment');
            $files_name = [];
            foreach($file as $files){
                $attachment = uniqid().'.'.$files->guessExtension();
                $attachment_path = $files->move(public_path().'/backend/media/attachments/',$attachment);
                array_push($files_name, $attachment);
            }
            $comma_file = implode(",",$files_name);
        }
        
        // dd($comma_file);
        $user = null;
        if(!empty($request->add_agent)){
            $user = $request->add_agent;
        }else{
            $user = session()->get('id');
        }
        
        $lead = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'message' => $request->client_message,
            'total_amount' => $request->total_amount,
            'paid_amount' => $request->paid_amount,
            'currency' => $request->curreny,
            'converted_total_amount' => $dollar_total_amount,
            'converted_paid_amount' => $dollar_paid_amount,
            'payment_method' => $request->payment_method,
            'client_type' => $request->client_type,
            'client_code' => $request->client_code,
            'status' => $request->lead_status,
            'lead_type' => "Manual",
            'progress_status' => $request->progress_status,
            'completion_date' => $request->cod,
            'chat_ref' => $request->chat_ref,
            'chat_ref_detail' => $request->chat_ref_detail,
            'attachment' => $comma_file,
            'brand_id' => $request->brand,
            'user_id' => $user,
            'assigned_by' => $request->assigned_by,
        ];

        $lead_id = DB::table('leads')->insertGetId($lead);

        if($lead_id){
            toastr()->success('Lead Add Successfully');
            return redirect()->route('unassignleads');
        }
        else{
            toastr()->error('Something went wrong');
            return redirect()->route('unassignleads');
        }
    }

    //update leads
    public function updatelead(Request $request){

        if(session()->get('id') != null){
            if(session()->get('department_id') == 1 || session()->get('department_id') == 2 || session()->get('department_id') == 3 ){
                // $validate = $request->validate([
                //     'name' => 'required',
                //     'email' => 'required',
                //     'phone' => 'required',
                //     'total_amount' => 'required',
                //     'paid_amount' => 'required',
                //     'edit_curreny' => 'required',
                //     'lead_status' => 'required',
                //     'cod' => 'required',
                //     'payment_method' => 'required',
                //     'chat_ref' => 'required',
                //     'client_code' => 'required',
                //     'chat_ref_detail' => 'required',
                // ]);
                $date = date('Y-m-d G:i:s');
        
                $json = json_decode(file_get_contents('https://openexchangerates.org/api/latest.json?app_id=96cb7e699fb840ebbfb1d682e1304b31&base=USD'), true);
                $currency_amount = array_column($json, $request->edit_curreny ?? 'USD');
                $dollar_total_amount = $request->total_amount ?? 0 / $currency_amount[0];
                $dollar_paid_amount = $request->paid_amount ?? 0 / $currency_amount[0];
        
                $brand_id = DB::table('brands')->where('name',$request->brandname)->first();
                $assign_user = 0;
                
                if(session()->get('usertype') == 2 || session()->get('usertype') == 3){
                    $assign_user = $request->edit_new_agent;
                }elseif(session()->get('usertype') == 1 || session()->get('usertype') == 4){
                    $assign_user = session()->get('id');
                }
                
                $progress_status = null;
                if($request->progress_status != null || $request->progress_status != ''){
                    $progress_status = $request->progress_status;
                }
                else{
                    $get_lead = DB::table('leads')->where('id',$request->leadid)-> first();
                    $progress_status = $get_lead->progress_status;
                }
                
                $attachment = "";
                if($request->hasFile('edit_lead_attachment')){
                    $file = $request->file('edit_lead_attachment');
                    $files_name = [];
                    foreach($file as $files){
                        
                        $attachment = uniqid().'.'.$files->guessExtension();
                        // $fi = [
                        //     "filename" => $attachment,  
                        // ];
                       
                        
                        $attachment_path = $files->move(public_path().'/backend/media/attachments/',$attachment);
                        array_push($files_name, $attachment);
                    }
                    $comma_file = implode(",",$files_name);
        
                    
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'total_amount' => $request->total_amount,
                        'paid_amount' => $request->paid_amount,
                        'currency' => $request->edit_curreny ?? 'USD',
                        'converted_total_amount' => $dollar_total_amount,
                        'converted_paid_amount' => $dollar_paid_amount,
                        'payment_method' => $request->payment_method,
                        'client_type' => "New",
                        'client_code' => $request->client_code,
                        'status' => $request->lead_status,
                        'progress_status' => $progress_status,
                        'completion_date' => $request->cod,
                        'chat_ref' => $request->chat_ref,
                        'chat_ref_detail' => $request->chat_ref_detail,
                        'attachment' => $comma_file,
                        'user_id' => $assign_user,
                        'assigned_by' => $request->assigned_by,
                        'updated_at' => $date,
                    ];
                }
                else{
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'total_amount' => $request->total_amount,
                        'paid_amount' => $request->paid_amount,
                        'currency' => $request->edit_curreny ?? 'USD',
                        'converted_total_amount' => $dollar_total_amount,
                        'converted_paid_amount' => $dollar_paid_amount,
                        'payment_method' => $request->payment_method,
                        'client_type' => "New",
                        'client_code' => $request->client_code,
                        'status' => $request->lead_status,
                        'progress_status' => $progress_status,
                        'completion_date' => $request->cod,
                        'chat_ref' => $request->chat_ref,
                        'chat_ref_detail' => $request->chat_ref_detail,
                        'user_id' => $assign_user,
                        'assigned_by' => $request->assigned_by,
                        'updated_at' => $date,
                    ];
                }
        
                
                $update_lead = DB::table('leads')->where('id', $request->leadid)->update($lead);
        
                if($update_lead){
                    $data = [
                        'lead_id' => $request->leadid,
                        'user_id' => $assign_user,
                        'lead_status' => 'New',
                    ];
                    $history = DB::table('lead_history')->insert($data);
                    if($history){
                        $currency_data = [
                            'currency' => $request->edit_curreny ?? 'USD',
                            'rate' => $currency_amount[0],
                            'created_at' => $date,
                            'updated_at' => $date,
                        ];
                        // dd($currency_data);
                        $insert_currency_log = DB::table('currency_log')->insert($currency_data);
                        if($insert_currency_log){
                            toastr()->success('Lead Update Successfully');
                            return redirect()->route('unassignleads');
                        }
                        else{
                            toastr()->error('Something went wrong while maintain currency log');
                            return redirect()->route('unassignleads');
                        }
                        
                    }
                    else{
                        toastr()->error('Something went wrong while maintain history');
                        return redirect()->route('unassignleads');
                    }
                    
                }
                else{
                    toastr()->error('Something went wrong');
                    return redirect()->route('unassignleads');
                }
            }elseif(session()->get('department_id') == 5){
                // $validate = $request->validate([
                //     'name' => 'required',
                //     'email' => 'required',
                //     'phone' => 'required',
                //     'cod' => 'required',
                // ]);
                $date = date('Y-m-d G:i:s');
        
                $production_status = null;
                if($request->production_status != null || $request->production_status != ''){
                    $production_status = $request->production_status;
                }
                else{
                    $get_lead = DB::table('leads')->where('id',$request->leadid)-> first();
                    $production_status = $get_lead->production_status;
                }
                
                $attachment = "";
                if($request->hasFile('edit_lead_attachment')){
                    $file = $request->file('edit_lead_attachment');
                    $files_name = [];
                    foreach($file as $files){
                        $attachment = uniqid().'.'.$files->guessExtension();
                        $attachment_path = $files->move(public_path().'/backend/media/attachments/',$attachment);
                        array_push($files_name, $attachment);
                    }
                    $comma_file = implode(",",$files_name);
        
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'status' => $request->lead_status,
                        'production_status' => $production_status,
                        'completion_date' => $request->cod,
                        'attachment' => $comma_file,
                        'updated_at' => $date,
                    ];
                }
                else{
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'status' => $request->lead_status,
                        'production_status' => $production_status,
                        'completion_date' => $request->cod,
                        'updated_at' => $date,
                    ];
                }
        
                
                $update_lead = DB::table('leads')->where('id', $request->leadid)->update($lead);
        
                if($update_lead){
                    
                    if(isset($request->edit_new_agent)){
                        if(session()->get('usertype') == 3){
                            $get_prev_managers = DB::table('production_task_assigning')
                                                ->select('production_task_assigning.*','users.id as user_table_id','users.usertype_id')
                                                ->leftjoin('users','production_task_assigning.user_id','users.id')
                                                ->where(['users.usertype_id' => 2, 'lead_id' => $request->leadid])
                                                ->get();
                            
                            if($get_prev_managers){
                                foreach($get_prev_managers as $g){
                                    DB::table('production_task_assigning')->where('id', $g->id)->delete();
                                }
                            }
                        }else{
                            $get_prev_agents = DB::table('production_task_assigning')
                                                ->select('production_task_assigning.*','users.id as user_table_id','users.usertype_id')
                                                ->leftjoin('users','production_task_assigning.user_id','users.id')
                                                ->where('users.usertype_id', 4)
                                                ->get();
                            if($get_prev_agents){
                                foreach($get_prev_agents as $g){
                                    DB::table('production_task_assigning')->where('id', $g->id)->delete();
                                }
                            }
                        }
                        
                        if(count($request->edit_new_agent) > 0){
                            
                            foreach($request->edit_new_agent as $dev){
                                $check_user = DB::table('production_task_assigning')->where(['lead_id' => $request->leadid, 'user_id' => $dev])->first();
                                if(empty($check_user)){
                                    $data = [
                                        "lead_id" => $request->leadid,
                                        "user_id" => $dev,
                                        "assigned_by" => session()->get('id'),
                                        'created_at' => $date,
                                        'updated_at' => $date,
                                    ];
                                    DB::table('production_task_assigning')->insert($data);
                                }
                            }
                        }
                    }
                    
                    if(isset($request->edit_new_agent_by_depart)){
                        $get_prev_agents = DB::table('production_task_assigning')
                                                ->select('production_task_assigning.*','users.id as user_table_id','users.usertype_id')
                                                ->leftjoin('users','production_task_assigning.user_id','users.id')
                                                ->where('users.usertype_id', 4)
                                                ->get();
                        if($get_prev_agents){
                            foreach($get_prev_agents as $g){
                                DB::table('production_task_assigning')->where('id', $g->id)->delete();
                            }
                        }
                        
                        if(count($request->edit_new_agent_by_depart) > 0){
                            
                            
                            foreach($request->edit_new_agent_by_depart as $dev){
                                $check_user = DB::table('production_task_assigning')->where(['lead_id' => $request->leadid, 'user_id' => $dev])->first();
                                if(empty($check_user)){
                                    $data = [
                                        "lead_id" => $request->leadid,
                                        "user_id" => $dev,
                                        "assigned_by" => session()->get('id'),
                                        'created_at' => $date,
                                        'updated_at' => $date,
                                    ];
                                    DB::table('production_task_assigning')->insert($data);
                                }
                            }
                        }
                    }
                    
                    $data = [
                        'lead_id' => $request->leadid,
                        'user_id' => session()->get('id'),
                        'lead_status' => 'New',
                    ];
                    $history = DB::table('lead_history')->insert($data);
                    if($history){
                        toastr()->success("Task updated successfully");
                        return redirect()->route('unassignleads');
                    }
                    else{
                        toastr()->error('Something went wrong while maintain history');
                        return redirect()->route('unassignleads');
                    }
                    
                }
                else{
                    toastr()->error('Something went wrong');
                    return redirect()->route('unassignleads');
                }
                
            }elseif(session()->get('department_id') == 8){
                // $validate = $request->validate([
                //     'name' => 'required',
                //     'email' => 'required',
                //     'phone' => 'required',
                //     'cod' => 'required',
                // ]);
                $date = date('Y-m-d G:i:s');
        
                $support_status = null;
                if($request->support_status != null || $request->support_status != ''){
                    $support_status = $request->support_status;
                }
                else{
                    $get_lead = DB::table('leads')->where('id',$request->leadid)-> first();
                    $support_status = $get_lead->support_status;
                }
                
                $attachment = "";
                if($request->hasFile('edit_lead_attachment')){
                    $file = $request->file('edit_lead_attachment');
                    $files_name = [];
                    foreach($file as $files){
                        $attachment = uniqid().'.'.$files->guessExtension();
                        $attachment_path = $files->move(public_path().'/backend/media/attachments/',$attachment);
                        array_push($files_name, $attachment);
                    }
                    $comma_file = implode(",",$files_name);
        
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'status' => $request->lead_status,
                        'support_status' => $support_status,
                        'completion_date' => $request->cod,
                        'attachment' => $comma_file,
                        'updated_at' => $date,
                    ];
                }
                else{
                    $lead = [
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'status' => $request->lead_status,
                        'support_status' => $support_status,
                        'completion_date' => $request->cod,
                        'updated_at' => $date,
                    ];
                }
        
                
                $update_lead = DB::table('leads')->where('id', $request->leadid)->update($lead);
        
                if($update_lead){
                    
                    // if(count($request->edit_new_agent) > 0){
                    //     DB::table('production_task_assigning')->where('lead_id', $request->leadid)->delete();
                    //     foreach($request->edit_new_agent as $dev){
                    //         $data = [
                    //             "lead_id" => $request->leadid,
                    //             "user_id" => $dev,
                    //             "assigned_by" => session()->get('id'),
                    //             'created_at' => $date,
                    //             'updated_at' => $date,
                    //         ];
                    //         DB::table('production_task_assigning')->insert($data);
                    //     }
                    // }
                    
                    $data = [
                        'lead_id' => $request->leadid,
                        'user_id' => session()->get('id'),
                        'lead_status' => 'New',
                    ];
                    $history = DB::table('lead_history')->insert($data);
                    if($history){
                        toastr()->success("Task updated successfully");
                        return redirect()->back();
                    }
                    else{
                        toastr()->error('Something went wrong while maintain history');
                        return redirect()->back();
                    }
                    
                }
                else{
                    toastr()->error('Something went wrong');
                    return redirect()->back();
                }
            }else{
                toastr()->error("Department Not Assigned");
                return redirect()->back();
            }
        }else{
            return redirect()->route('login');
        }
    }

    //upsale update leads
    public function upsaleLead(Request $request){
        $validate = $request->validate([
            'upsale_client_message' => 'required',
            'upsale_total_amount' => 'required',
            'upsale_paid_amount' => 'required',
            'upsale_curreny' => 'required',
            'upsale_progress_status' => 'required',
            'upsale_lead_status' => 'required',
            'upsale_cod' => 'required',
            'upsale_payment_method' => 'required',
            'upsale_chat_ref' => 'required',
            'upsale_chat_ref_detail' => 'required',
        ]);
        $date = date('Y-m-d G:i:s');

        $json = json_decode(file_get_contents('https://openexchangerates.org/api/latest.json?app_id=96cb7e699fb840ebbfb1d682e1304b31&base=USD'), true);
        $currency_amount = array_column($json, $request->upsale_curreny);
        $dollar_total_amount = $request->upsale_total_amount / $currency_amount[0];
        $dollar_paid_amount = $request->upsale_paid_amount / $currency_amount[0];

        $brand_id = DB::table('brands')->where('name',$request->upsale_brand)->first();
        $assign_user = 0;
        if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
            $assign_user = $request->edit_upsale_agent;
        }elseif(session()->get('usertype') == 1 || session()->get('usertype') == 4){
            $assign_user = session()->get('id');
        }
        
        $attachment = "";
        if($request->hasFile('edit_lead_upsale_attachment')){
            $file = $request->file('edit_lead_upsale_attachment');
            $files_name = [];
            foreach($file as $files){
                
                $attachment = uniqid().'.'.$files->guessExtension();
                // $fi = [
                //     "filename" => $attachment,  
                // ];
               
                
                $attachment_path = $files->move(public_path().'/backend/media/attachments/',$attachment);
                array_push($files_name, $attachment);
            }
            $comma_file = implode(",",$files_name);
            
            $lead = [
                'client_message' => $request->upsale_client_message,
                'client_type' => "Upsale",
                'total_amount' => $request->upsale_total_amount,
                'paid_amount' => $request->upsale_paid_amount,
                'currency' => $request->upsale_curreny,
                'converted_total_amount' => $dollar_total_amount,
                'converted_paid_amount' => $dollar_paid_amount,
                'payment_method' => $request->upsale_payment_method,
                'status' => $request->upsale_lead_status,
                'progress_status' => $request->upsale_progress_status,
                'completion_date' => $request->upsale_cod,
                'chat_ref' => $request->upsale_chat_ref,
                'chat_ref_detail' => $request->upsale_chat_ref_detail,
                'attachment' => $comma_file,
                'lead_id' => $request->leadid,
                'user_id' => $assign_user,
                'updated_at' => $date,
            ];
        }else{
            $lead = [
                'client_message' => $request->upsale_client_message,
                'client_type' => "Upsale",
                'total_amount' => $request->upsale_total_amount,
                'paid_amount' => $request->upsale_paid_amount,
                'currency' => $request->upsale_curreny,
                'converted_total_amount' => $dollar_total_amount,
                'converted_paid_amount' => $dollar_paid_amount,
                'payment_method' => $request->upsale_payment_method,
                'status' => $request->upsale_lead_status,
                'progress_status' => $request->upsale_progress_status,
                'completion_date' => $request->upsale_cod,
                'chat_ref' => $request->upsale_chat_ref,
                'chat_ref_detail' => $request->upsale_chat_ref_detail,
                'attachment' => $attachment,
                'lead_id' => $request->leadid,
                'user_id' => $assign_user,
                'updated_at' => $date,
            ];
        }

        $check_upsale_lead = DB::table('upsales')->where('lead_id', $request->leadid)->first();
        if(empty($check_upsale_lead)){

            $insert_upsale_lead = DB::table('upsales')->insertGetId($lead);

        }
        else{
            $insert_upsale_lead = DB::table('upsales')->where('lead_id', $request->leadid)->update($lead);
        }
        

        if($insert_upsale_lead){
            $data = [
                'lead_id' => $insert_upsale_lead,
                'user_id' => $assign_user,
                'lead_status' => 'Upsale',
            ];
            $history = DB::table('lead_history')->insert($data);
            if($history){
                $currency_data = [
                    'currency' => $request->upsale_curreny,
                    'rate' => $currency_amount[0],
                    'created_at' => $date,
                    'updated_at' => $date,
                ];
                $insert_currency_log = DB::table('currency_log')->insert($currency_data);
                if($insert_currency_log){
                    toastr()->success('Lead Update Successfully');
                    return redirect()->route('unassignleads');
                }
                else{
                    toastr()->error('Something went wrong while maintain currency log');
                    return redirect()->route('unassignleads');
                }
            }
            else{
                toastr()->error('Something went wrong while maintain history');
                return redirect()->route('unassignleads');
            }
            
        }
        else{
            toastr()->error('Something went wrong');
            return redirect()->route('unassignleads');
        }
    }

    //delete lead
    public function deletelead(Request $request){

        if(session()->get('id') != null){

            $check_lead = DB::table('leads')
                ->where('id',$request->deleteleadid)
                ->delete();
            
            $assign_lead = DB::table('assign_leads')
                ->where('lead_id',$request->deleteleadid)
                ->delete();
            DB::table('production_task_assigning')
                ->where('lead_id',$request->deleteleadid)
                ->delete();
            if($check_lead){
                toastr()->success('Lead Delete Successfully');
                return redirect()->route('unassignleads');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('unassignleads');
            }
        }
        else{
            return redirect()->route('login');
        }
    }

    public function contentOrderLead(){
        if(session()->get('id') != null){
            $orders = [];
            if(session()->get('usertype') == 1){

                $content = DB::table('content_order')
                    ->select('content_order.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                    ->leftjoin('brands','brands.id','content_order.brand_id')
                    ->leftjoin('users','users.id','content_order.user_id')
                    ->orderby('content_order.id', 'DESC')
                    ->get();
                if(!empty($content)){
                    foreach ($content as $rows) {
                        $data = [
                            'id' => $rows->id,
                            'name' => $rows->name,
                            'email' => $rows->email,
                            'phone' => $rows->phone,
                            'edu_level' => $rows->edu_level,
                            'paper_type' => $rows->paper_type,
                            'no_of_pages' => $rows->no_of_pages,
                            'paper_quality' => $rows->paper_quality,
                            'word_count' => $rows->word_count,
                            'delievery_time' => $rows->delievery_time,
                            'assisted' => $rows->assisted,
                            'citation' => $rows->citation,
                            'major' => $rows->major,
                            'topic' => $rows->topic,
                            'reference' => $rows->reference,
                            'paper_des' => $rows->paper_des,
                            'extra_req' => $rows->extra_req,
                            'status' => $rows->status,
                            'brand_id' => $rows->brand_id,
                            'user_id' => $rows->user_id,
                            'created_at' => $rows->created_at,
                            'updated_at' => $rows->updated_at,
                            'brandname' => $rows->brandname,
                            'first_name' => $rows->first_name,
                            'last_name' => $rows->last_name,
                            'image' => $rows->image,
                        ];
                        array_push($orders, $data);
                    }
                }

                return view('pages.content-order',compact('orders'));
            }
            elseif(session()->get('usertype') == 3 || session()->get('usertype') == 2 || session()->get('usertype') == 4){
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                if(!empty($brands)){
                    foreach ($brands as $row) {
                        $content = DB::table('content_order')
                            ->select('content_order.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                            ->leftjoin('brands','brands.id','content_order.brand_id')
                            ->leftjoin('users','users.id','content_order.user_id')
                            ->where('content_order.brand_id',$row->brand_id)
                            ->orderby('content_order.id', 'DESC')
                            ->get();
                        
                        if(!empty($content)){
                            foreach ($content as $rows) {
                                    $data = [
                                        'id' => $rows->id,
                                        'name' => $rows->name,
                                        'email' => $rows->email,
                                        'phone' => $rows->phone,
                                        'edu_level' => $rows->edu_level,
                                        'paper_type' => $rows->paper_type,
                                        'no_of_pages' => $rows->no_of_pages,
                                        'paper_quality' => $rows->paper_quality,
                                        'word_count' => $rows->word_count,
                                        'delievery_time' => $rows->delievery_time,
                                        'assisted' => $rows->assisted,
                                        'citation' => $rows->citation,
                                        'major' => $rows->major,
                                        'topic' => $rows->topic,
                                        'reference' => $rows->reference,
                                        'paper_des' => $rows->paper_des,
                                        'extra_req' => $rows->extra_req,
                                        'status' => $rows->status,
                                        'brand_id' => $rows->brand_id,
                                        'user_id' => $rows->user_id,
                                        'created_at' => $rows->created_at,
                                        'updated_at' => $rows->updated_at,
                                        'brandname' => $rows->brandname,
                                        'first_name' => $rows->first_name,
                                        'last_name' => $rows->last_name,
                                        'image' => $rows->image,
                                 ];
                                    array_push($orders, $data);
                            }
                        }
                    }
                }
                rsort($orders);
                return view('pages.content-order',compact('orders'));
            }
        }
        else{
            return redirect()->route('login');
        }
    }
    
    //delete lead
    public function deleteContentOrder(Request $request){

        if(session()->get('id') != null){

            $check_lead = DB::table('content_order')
                ->where('id',$request->deleteleadid)
                ->delete();
            if($check_lead){
                toastr()->success('Content Order Delete Successfully');
                return redirect()->route('content-order-lead');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('content-order-lead');
            }
        }
        else{
            return redirect()->route('login');
        }
    }

    public function designOrderLead(){
        if(session()->get('id') != null){
            $orders = [];
            if(session()->get('usertype') == 1){
                $design = DB::table('design_order')
                        ->select('design_order.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                        ->leftjoin('brands','brands.id','design_order.brand_id')
                        ->leftjoin('users','users.id','design_order.user_id')
                        ->orderby('design_order.id','desc')
                        ->get();
                if(!empty($design)){
                    foreach($design as $row){
                        $data = [
                            'id' => $row->id,
                            'name' => $row->name,
                            'email' => $row->email,
                            'logo_name' => $row->logo_name,
                            'company_slogan' => $row->company_slogan,
                            'competitors_reference' => $row->competitors_reference,
                            'des_your_business' => $row->des_your_business,
                            'want_logo' => $row->want_logo,
                            'primary_color' => $row->primary_color,
                            'secondary_color' => $row->secondary_color,
                            'person_name' => $row->person_name,
                            'person_email' => $row->person_email,
                            'person_designation' => $row->person_designation,
                            'person_phone' => $row->person_phone,
                            'company_address' => $row->company_address,
                            'company_phone' => $row->company_phone,
                            'status' => $row->status,
                            'brand_id' => $row->brand_id,
                            'user_id' => $row->user_id,
                            'created_at' => $row->created_at,
                            'updated_at' => $row->updated_at,
                            'brandname' => $row->brandname,
                            'first_name' => $row->first_name,
                            'last_name' => $row->last_name,
                            'image' => $row->image,
                        ];
                        array_push($orders, $data);
                    }
                }
                return view('pages.design-order',compact('orders'));
            }
            elseif(session()->get('usertype') == 3 || session()->get('usertype') == 2  || session()->get('usertype') == 4){

                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                if(!empty($brands)){
                    foreach ($brands as $rows) {
                        $design = DB::table('design_order')
                                    ->select('design_order.*','brands.name as brandname','users.first_name','users.last_name','users.image')
                                    ->leftjoin('brands','brands.id','design_order.brand_id')
                                    ->leftjoin('users','users.id','design_order.user_id')
                                    ->where('design_order.brand_id',$rows->brand_id)
                                    ->get();
                        if(!empty($design)){
                            foreach($design as $row){
                                $data = [
                                    'id' => $row->id,
                                    'name' => $row->name,
                                    'email' => $row->email,
                                    'logo_name' => $row->logo_name,
                                    'company_slogan' => $row->company_slogan,
                                    'competitors_reference' => $row->competitors_reference,
                                    'des_your_business' => $row->des_your_business,
                                    'want_logo' => $row->want_logo,
                                    'primary_color' => $row->primary_color,
                                    'secondary_color' => $row->secondary_color,
                                    'person_name' => $row->person_name,
                                    'person_email' => $row->person_email,
                                    'person_designation' => $row->person_designation,
                                    'person_phone' => $row->person_phone,
                                    'company_address' => $row->company_address,
                                    'company_phone' => $row->company_phone,
                                    'status' => $row->status,
                                    'brand_id' => $row->brand_id,
                                    'user_id' => $row->user_id,
                                    'created_at' => $row->created_at,
                                    'updated_at' => $row->updated_at,
                                    'brandname' => $row->brandname,
                                    'first_name' => $row->first_name,
                                    'last_name' => $row->last_name,
                                    'image' => $row->image,
                                ];
                                array_push($orders, $data);
                            }
                        }
                    }
                }
                rsort($orders);
                return view('pages.design-order',compact('orders'));
            }

        }
        else{
            return redirect()->route('login');
        }
    }
    //delete lead
    public function deleteDesignOrder(Request $request){

        if(session()->get('id') != null){

            $check_lead = DB::table('design_order')
                ->where('id',$request->deleteleadid)
                ->delete();
            if($check_lead){
                toastr()->success('Design Order Delete Successfully');
                return redirect()->route('design-order-lead');
            }
            else{
                toastr()->error('Something went wrong while deleting');
                return redirect()->route('design-order-lead');
            }
        }
        else{
            return redirect()->route('login');
        }
    }
    
    /*
    For Support Department Methods
    */
    public function allLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                                
                            }
                        }
                    }
                }
                rsort($leads);
                // dd($leads);
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.all',compact('leads','brands','agents', 'type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.all',compact('leads','brands','type', 'total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function welcomeLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Welcome', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                        
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order)  ){
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                                
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order)  || !empty($get_lead__social_media_order) || !empty($get_lead__content_order)  ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.welcome',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.welcome',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function initialSendLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Initial sent', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order)  ){
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order)  ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.initial-send',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.initial-send',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function feedbackRevisionLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Revision to sent', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.feedback-revision',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.feedback-revision',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function feedbackWaitingLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Waiting for feedback', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.feedback-waiting',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.feedback-waiting',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function approvedLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Approved', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order)  || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.approved',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.approved',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    public function finalFilesLeads($type){
        $total_count = 0;
        $welcome_count = 0;
        $initial_send_count = 0;
        $revision_to_sent_count = 0;
        $waiting_for_feedback_count = 0;
        $approved_count = 0;
        $final_files_count = 0;
        if(session()->get('id') != null){
            if( session()->get('department_id') == 8 ){
                $leads = [];
                // if(session()->get('usertype') == 3){
                //         $brands = DB::table('brands')
                //                 ->get();    
                // }else{
                //     $brands = DB::table('production_task_assigning')
                //             ->where('user_id', session()->get('id'))
                //             ->get();
                // }
                
                $brands = DB::table('brand_assign')
                            ->select('brand_assign.id as brand_assign_id','brand_assign.brand_id','brand_assign.assign_user_id','brands.id','brands.name')
                            ->leftjoin('brands','brands.id','brand_assign.brand_id')
                            ->where('assign_user_id',session()->get('id'))
                            ->get();
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
                                ->leftjoin('brands','brands.id','leads.brand_id')
                                ->leftjoin('users','users.id','leads.user_id')
                                ->where(['leads.progress_status' => 'Completed', 'support_status' => 'Final Files/Try Upsell', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        
                        if(!empty($le)){
                            foreach($le as $row){
                                $check_upsale_lead = DB::table('upsales')
                                                        ->select('upsales.*','users.first_name','users.last_name','users.image')
                                                        ->leftjoin('users','users.id','upsales.user_id')
                                                        ->where('lead_id',$row->id)->first();
                                
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order) ){
                                    $get_production = DB::table('production_task_assigning')
                                                        ->select('production_task_assigning.*', 'users.first_name as pro_user_first_name','users.last_name as pro_user_last_name')
                                                        ->leftjoin('users','users.id','production_task_assigning.user_id')
                                                        ->where('lead_id', $row->id)->get();
                                    
                                    $data = [
                                        'id' => $row->id,
                                        'name' => $row->name,
                                        'email' => $row->email,
                                        'phone' => $row->phone,
                                        'message' => $row->message,
                                        'total_amount' => $row->total_amount,
                                        'paid_amount' => $row->paid_amount,
                                        'currency' => $row->currency,
                                        'payment_method' => $row->payment_method,
                                        'client_type' => $row->client_type,
                                        'client_code' => $row->client_code,
                                        'status' => $row->status,
                                        'lead_type' => $row->lead_type,
                                        'progress_status' => $row->progress_status,
                                        'production_status' => $row->production_status,
                                        'support_status' => $row->support_status,
                                        'completion_date' => $row->completion_date,
                                        'chat_ref' => $row->chat_ref,
                                        'chat_ref_detail' => $row->chat_ref_detail,
                                        'brand_id' => $row->brand_id,
                                        'user_id' => $row->user_id,
                                        'created_at' => $row->created_at,
                                        'updated_at' => $row->updated_at,
                                        'brandname' => $row->brandname,
                                        'brandurl' => $row->brandurl,
                                        'first_name' => $row->first_name,
                                        'last_name' => $row->last_name,
                                        'image' => $row->image,
                                        'attachment' => $row->attachment,
                                        'upsale' => $check_upsale_lead,
                                        'production_user' => $get_production ?? null,
                                        'lead_logo_order_id' => $get_lead__logo_order ?? null,
                                        'lead_website_order_id' => $get_lead__website_order ?? null,
                                        'lead_stationary_order_id' => $get_lead__stationary_order ?? null,
                                        'lead_social_media_order_id' => $get_lead__social_media_order ?? null,
                                        'lead_content_order_id' => $get_lead__content_order ?? null,
                                    ];
                                    array_push($leads, $data);
                                    
                                }
                            }
                        }
                    }
                }
                rsort($leads);
                
                if(!empty($brands)){
                    foreach($brands as $row){
                        // For Support
                        // if(session()->get('usertype') == 3){
                            $le = DB::table('leads')
                                ->where(['leads.progress_status' => 'Completed', 'leads.brand_id'=> $row->id])
                                ->orderby('updated_at', 'desc')
                                ->get();
                              
                        // }else{
                        //     $le = DB::table('leads')
                        //         ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
                        //         ->leftjoin('brands','brands.id','leads.brand_id')
                        //         ->leftjoin('users','users.id','leads.user_id')
                        //         ->where('leads.id',$row->lead_id)
                        //         ->orderby('updated_at', 'desc')
                        //         ->get();
                        // }
                        
                        if(!empty($le)){
                            foreach($le as $row){
                               
                                if($type == 'logo'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'website'){
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'stationary'){
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'social-media'){
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'design-content'){
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }elseif($type == 'universal'){
                                    $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                    $get_lead__stationary_order = DB::table('stationary_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__social_media_order = DB::table('social_media_questionnaire')->where(['lead_id' => $row->id])->first();
                                    $get_lead__content_order = DB::table('design_content_questionnair')->where(['lead_id' => $row->id])->first();
                                }
                                
                                if(!empty($get_lead__logo_order) || !empty($get_lead__website_order) || !empty($get_lead__stationary_order) || !empty($get_lead__social_media_order) || !empty($get_lead__content_order)  ){
                                    
                                    if($row->support_status == 'Welcome'){
                                        $welcome_count++;
                                    }elseif($row->support_status == 'Initial sent'){
                                        $initial_send_count++;
                                    }elseif($row->support_status == 'Revision to sent'){
                                        $revision_to_sent_count++;
                                    }elseif($row->support_status == 'Waiting for feedback'){
                                        $waiting_for_feedback_count++;
                                    }elseif($row->support_status == 'Approved'){
                                        $approved_count++;
                                    }elseif($row->support_status == 'Final Files/Try Upsell'){
                                        $final_files_count++;
                                    }
                                    
                                    $total_count++;
                                }
                            }
                        }
                    }
                }
                
                
                if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
                    $agents = DB::table('users')
                                ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
                                ->leftjoin('usertype','usertype.id','users.usertype_id')
                                ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
                                ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
                                ->where('parent_user_id',session()->get('id'))
                                ->get();
                    
                    return view('pages.support.final-files',compact('leads','brands','agents','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                else{
                    return view('pages.support.final-files',compact('leads','brands','type','total_count','welcome_count','initial_send_count','revision_to_sent_count','waiting_for_feedback_count','approved_count','final_files_count'));
                }
                
                
            }else{
                toastr()->warning("You are not authorized for in this department");
                return redirect()->back();
            }
        }else{
            toastr()->warning("Session has been expired");
            return redirect()->route('login');
        }
    }
    
    // public function initialSendLeads(){
    //     if(session()->get('id') != null){
    //         if( session()->get('department_id') == 8 ){
    //             $leads = [];
    //             if(session()->get('usertype') == 3){
    //                     $brands = DB::table('brands')
    //                             ->get();    
    //             }else{
    //                 $brands = DB::table('production_task_assigning')
    //                         ->where('user_id', session()->get('id'))
    //                         ->get();
    //             }
                
    //             if(!empty($brands)){
    //                 foreach($brands as $row){
    //                     // For Support
    //                     if(session()->get('usertype') == 3){
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Initial sent', 'leads.brand_id'=> $row->id])
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
                              
    //                     }else{
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where('leads.id',$row->lead_id)
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
    //                     }
                        
                        
    //                     if(!empty($le)){
    //                         foreach($le as $row){
    //                             $check_upsale_lead = DB::table('upsales')
    //                                                     ->select('upsales.*','users.first_name','users.last_name','users.image')
    //                                                     ->leftjoin('users','users.id','upsales.user_id')
    //                                                     ->where('lead_id',$row->id)->first();
    //                             $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
    //                             $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                
    //                             if(!empty($check_upsale_lead)){
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => $check_upsale_lead,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             else{
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => null,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             array_push($leads, $data);
    //                         }
    //                     }
    //                 }
    //             }
    //             rsort($leads);
                
    //             if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
    //                 $agents = DB::table('users')
    //                             ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
    //                             ->leftjoin('usertype','usertype.id','users.usertype_id')
    //                             ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
    //                             ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
    //                             ->where('parent_user_id',session()->get('id'))
    //                             ->get();
                    
    //                 return view('pages.support.initial-send',compact('leads','brands','agents'));
    //             }
    //             else{
    //                 return view('pages.support.initial-send',compact('leads','brands'));
    //             }
                
                
    //         }else{
    //             toastr()->warning("You are not authorized for in this department");
    //             return redirect()->back();
    //         }
    //     }else{
    //         toastr()->warning("Session has been expired");
    //         return redirect()->route('login');
    //     }
    // }
    
    // public function feedbackRevisionLeads(){
    //     if(session()->get('id') != null){
    //         if( session()->get('department_id') == 8 ){
    //             $leads = [];
    //             if(session()->get('usertype') == 3){
    //                     $brands = DB::table('brands')
    //                             ->get();    
    //             }else{
    //                 $brands = DB::table('production_task_assigning')
    //                         ->where('user_id', session()->get('id'))
    //                         ->get();
    //             }
                
    //             if(!empty($brands)){
    //                 foreach($brands as $row){
    //                     // For Support
    //                     if(session()->get('usertype') == 3){
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Revision to sent', 'leads.brand_id'=> $row->id])
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
                              
    //                     }else{
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where('leads.id',$row->lead_id)
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
    //                     }
                        
                        
    //                     if(!empty($le)){
    //                         foreach($le as $row){
    //                             $check_upsale_lead = DB::table('upsales')
    //                                                     ->select('upsales.*','users.first_name','users.last_name','users.image')
    //                                                     ->leftjoin('users','users.id','upsales.user_id')
    //                                                     ->where('lead_id',$row->id)->first();
    //                             $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
    //                             $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                
    //                             if(!empty($check_upsale_lead)){
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => $check_upsale_lead,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             else{
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => null,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             array_push($leads, $data);
    //                         }
    //                     }
    //                 }
    //             }
    //             rsort($leads);
                
    //             if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
    //                 $agents = DB::table('users')
    //                             ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
    //                             ->leftjoin('usertype','usertype.id','users.usertype_id')
    //                             ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
    //                             ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
    //                             ->where('parent_user_id',session()->get('id'))
    //                             ->get();
                    
    //                 return view('pages.support.feedback-revision',compact('leads','brands','agents'));
    //             }
    //             else{
    //                 return view('pages.support.feedback-revision',compact('leads','brands'));
    //             }
                
                
    //         }else{
    //             toastr()->warning("You are not authorized for in this department");
    //             return redirect()->back();
    //         }
    //     }else{
    //         toastr()->warning("Session has been expired");
    //         return redirect()->route('login');
    //     }
    // }
    
    // public function feedbackWaitingLeads(){
    //     if(session()->get('id') != null){
    //         if( session()->get('department_id') == 8 ){
    //             $leads = [];
    //             if(session()->get('usertype') == 3){
    //                     $brands = DB::table('brands')
    //                             ->get();    
    //             }else{
    //                 $brands = DB::table('production_task_assigning')
    //                         ->where('user_id', session()->get('id'))
    //                         ->get();
    //             }
                
    //             if(!empty($brands)){
    //                 foreach($brands as $row){
    //                     // For Support
    //                     if(session()->get('usertype') == 3){
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Waiting for feedback', 'leads.brand_id'=> $row->id])
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
                              
    //                     }else{
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where('leads.id',$row->lead_id)
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
    //                     }
                        
                        
    //                     if(!empty($le)){
    //                         foreach($le as $row){
    //                             $check_upsale_lead = DB::table('upsales')
    //                                                     ->select('upsales.*','users.first_name','users.last_name','users.image')
    //                                                     ->leftjoin('users','users.id','upsales.user_id')
    //                                                     ->where('lead_id',$row->id)->first();
    //                             $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
    //                             $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                
    //                             if(!empty($check_upsale_lead)){
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => $check_upsale_lead,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             else{
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => null,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             array_push($leads, $data);
    //                         }
    //                     }
    //                 }
    //             }
    //             rsort($leads);
                
    //             if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
    //                 $agents = DB::table('users')
    //                             ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
    //                             ->leftjoin('usertype','usertype.id','users.usertype_id')
    //                             ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
    //                             ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
    //                             ->where('parent_user_id',session()->get('id'))
    //                             ->get();
                    
    //                 return view('pages.support.feedback-waiting',compact('leads','brands','agents'));
    //             }
    //             else{
    //                 return view('pages.support.feedback-waiting',compact('leads','brands'));
    //             }
                
                
    //         }else{
    //             toastr()->warning("You are not authorized for in this department");
    //             return redirect()->back();
    //         }
    //     }else{
    //         toastr()->warning("Session has been expired");
    //         return redirect()->route('login');
    //     }
    // }
    
    // public function approvedLeads(){
    //     if(session()->get('id') != null){
    //         if( session()->get('department_id') == 8 ){
    //             $leads = [];
    //             if(session()->get('usertype') == 3){
    //                     $brands = DB::table('brands')
    //                             ->get();    
    //             }else{
    //                 $brands = DB::table('production_task_assigning')
    //                         ->where('user_id', session()->get('id'))
    //                         ->get();
    //             }
                
    //             if(!empty($brands)){
    //                 foreach($brands as $row){
    //                     // For Support
    //                     if(session()->get('usertype') == 3){
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname','brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where(['leads.progress_status' => 'Completed', 'leads.support_status' => 'Approved', 'leads.brand_id'=> $row->id])
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
                              
    //                     }else{
    //                         $le = DB::table('leads')
    //                             ->select('leads.*','brands.name as brandname', 'brands.url as brandurl','users.first_name','users.last_name','users.image')
    //                             ->leftjoin('brands','brands.id','leads.brand_id')
    //                             ->leftjoin('users','users.id','leads.user_id')
    //                             ->where('leads.id',$row->lead_id)
    //                             ->orderby('updated_at', 'desc')
    //                             ->get();
    //                     }
                        
                        
    //                     if(!empty($le)){
    //                         foreach($le as $row){
    //                             $check_upsale_lead = DB::table('upsales')
    //                                                     ->select('upsales.*','users.first_name','users.last_name','users.image')
    //                                                     ->leftjoin('users','users.id','upsales.user_id')
    //                                                     ->where('lead_id',$row->id)->first();
    //                             $get_lead__logo_order = DB::table('logo_questionnair')->where(['lead_id' => $row->id])->first();
    //                             $get_lead__website_order = DB::table('website_questionnair')->where(['lead_id' => $row->id])->first();
                                
    //                             if(!empty($check_upsale_lead)){
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => $check_upsale_lead,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             else{
    //                                 $data = [
    //                                     'id' => $row->id,
    //                                     'name' => $row->name,
    //                                     'email' => $row->email,
    //                                     'phone' => $row->phone,
    //                                     'message' => $row->message,
    //                                     'total_amount' => $row->total_amount,
    //                                     'paid_amount' => $row->paid_amount,
    //                                     'currency' => $row->currency,
    //                                     'payment_method' => $row->payment_method,
    //                                     'client_type' => $row->client_type,
    //                                     'client_code' => $row->client_code,
    //                                     'status' => $row->status,
    //                                     'lead_type' => $row->lead_type,
    //                                     'progress_status' => $row->progress_status,
    //                                     'production_status' => $row->production_status,
    //                                     'support_status' => $row->support_status,
    //                                     'completion_date' => $row->completion_date,
    //                                     'chat_ref' => $row->chat_ref,
    //                                     'chat_ref_detail' => $row->chat_ref_detail,
    //                                     'brand_id' => $row->brand_id,
    //                                     'user_id' => $row->user_id,
    //                                     'created_at' => $row->created_at,
    //                                     'updated_at' => $row->updated_at,
    //                                     'brandname' => $row->brandname,
    //                                     'brandurl' => $row->brandurl,
    //                                     'first_name' => $row->first_name,
    //                                     'last_name' => $row->last_name,
    //                                     'image' => $row->image,
    //                                     'attachment' => $row->attachment,
    //                                     'upsale' => null,
    //                                     'lead_logo_order_id' => $get_lead__logo_order->id ?? null,
    //                                     'lead_website_order_id' => $get_lead__website_order->id ?? null,
    //                                 ];
    //                             }
    //                             array_push($leads, $data);
    //                         }
    //                     }
    //                 }
    //             }
    //             rsort($leads);
                
    //             if(session()->get('usertype') == 3 || session()->get('usertype') == 2){
    //                 $agents = DB::table('users')
    //                             ->select('users.*', 'usertype.name as usertype_name','sub_department_assign.sub_department_id' ,'sub_department_assign.user_id', 'sub_departments.name as sub_department_name')
    //                             ->leftjoin('usertype','usertype.id','users.usertype_id')
    //                             ->leftjoin('sub_department_assign', 'users.id', 'sub_department_assign.user_id')
    //                             ->leftjoin('sub_departments', 'sub_departments.id', 'sub_department_assign.sub_department_id')
    //                             ->where('parent_user_id',session()->get('id'))
    //                             ->get();
                    
    //                 return view('pages.support.feedback-waiting',compact('leads','brands','agents'));
    //             }
    //             else{
    //                 return view('pages.support.feedback-waiting',compact('leads','brands'));
    //             }
                
                
    //         }else{
    //             toastr()->warning("You are not authorized for in this department");
    //             return redirect()->back();
    //         }
    //     }else{
    //         toastr()->warning("Session has been expired");
    //         return redirect()->route('login');
    //     }
    // }
}
