<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Page wrapper  -->
<!-- ============================================================== -->
<div class="page-wrapper">
    <!-- ============================================================== -->
    <!-- Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">Agents</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item">agents</li>
                <li class="breadcrumb-item active">Agents</li>
            </ol>
        </div>
        <div>

        </div>
    </div>
    <!-- ============================================================== -->
    <!-- End Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">
        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
        <div class="row">
            <div class="col-12">

                <div class="card">
                    <div class="card-body">

                        <button type="button" class="btn btn-info btn-circle" data-toggle="modal" data-target="#addagentModal" style="float:right;">
                            <i class="fa fa-plus"></i>
                        </button>

                        <h4 class="card-title">Agents</h4>
                        <h6 class="card-subtitle">Agents</h6>
                        <div class="table-responsive m-t-40">
                            <table id="agentTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row->first_name); ?></td>
                                    <td><?php echo e($row->last_name); ?></td>
                                    <td><?php echo e($row->email); ?></td>
                                    <td><?php echo e($row->phone_number); ?></td>
                                    <td class="text-nowrap">
                                        <a href="javascript:void(0)" class="btnSelect" data-toggle="tooltip" data-original-title="Edit" data-action="edit" data-rowid="<?php echo e($row->id); ?>"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="javascript:void(0)" class="btnSelect" data-toggle="tooltip" data-original-title="Close" data-action="delete" data-rowid="<?php echo e($row->id); ?>"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>






                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- ============================================================== -->
        <!-- End PAge Content -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Right sidebar -->
        <!-- ============================================================== -->
        <!-- .right-sidebar -->

        <!-- ============================================================== -->
        <!-- End Right sidebar -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->

<!-- Add Action Modal -->
<div class="modal fade" id="addagentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Add Agent</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                <div class="container-fluid">

                    <form class="form-material m-t-40" method="POST" action="<?php echo e(route('add_agents')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label>First Name</label>
                            <input type="text" class="form-control" name="first_name" value="" placeholder="first name" required>
                        </div>
                        <div class="form-group">
                            <label>Last Name</label>
                            <input type="text" class="form-control" name="last_name" value="" placeholder="last name" required>
                        </div>
                        <div class="form-group">
                            <label>Email Address</label>
                            <input type="email" class="form-control" name="email" value="" placeholder="agent@staffshaw.com" required>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" class="form-control" name="password" value="" placeholder="password" required>
                        </div>
                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="number" class="form-control" name="number" value="" placeholder="03***" required>
                        </div>

                        <input type="hidden" name="id" value="<?php echo e(Session::get('id')); ?>">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex bd-highlight align-items-center">

                                    <div class="flex-grow-1 p-2 bd-highlight">
                                        <button type="submit" class="btn btn-primary form-control">Add Agents</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>

                </div>

            </div>

        </div>
    </div>
</div>

<!-- Edit Action Modal -->
<div class="modal fade" id="editagentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Edit Agent</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                <div class="container-fluid">
                    <form class="form-material m-t-40" method="POST" action="<?php echo e(route('update_agents')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label>First Name</label>
                            <input type="text" class="form-control first_name" name="first_name" value="" placeholder="first name" required>
                        </div>
                        <div class="form-group">
                            <label>Last Name</label>
                            <input type="text" class="form-control last_name" name="last_name" value="" placeholder="last name" required>
                        </div>
                        <div class="form-group">
                            <label>Email Address</label>
                            <input type="email" class="form-control email" name="email" value="" placeholder="agent@staffshaw.com" required>
                        </div>




                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="number" class="form-control number" name="number" value="" placeholder="03***" required>
                        </div>

                        <input type="hidden" name="id" value="<?php echo e(Session::get('id')); ?>">
                        <input type="hidden" name="editagentid" value="" class="editagentid">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex bd-highlight align-items-center">

                                    <div class="flex-grow-1 p-2 bd-highlight">
                                        <button type="submit" class="btn btn-primary form-control">Update</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>

            </div>

        </div>
    </div>
</div>

<!-- Delete Action Modal-->
<div id="deleteagentModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-confirm modal-dialog-centered">
        <div class="modal-content">
            <!-- <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div> -->
            <div class="modal-body" align="center">
                <img src="<?php echo e(asset('public/assets/images/close.png')); ?>" width="70" height="70">
                <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                <p style="color: #999999">Do you really want to delete this records?</p>
                <form method="POST" action="<?php echo e(route('delete_agents')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="deleteagentid" class="deleteagentid" id="deleteleadblastid">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-info" data-dismiss="modal">Cancel</button>
                </form>
            </div>
            <!-- <div class="modal-footer" align="center">

            </div> -->
        </div>
    </div>
</div>

<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">

    $(document).ready(function(){

        // code to read selected table row cell data (values).
        $("#agentTable").on('click','.btnSelect',function(){

                var action = $(this).data('action');
                var rowid = $(this).data('rowid');

                if(action == 'edit'){

                    // get the current row
                    var currentRow = $(this).closest("tr");

                    var firstname = currentRow.find("td:eq(0)").text();
                    var lastname = currentRow.find("td:eq(1)").text();
                    var email = currentRow.find("td:eq(2)").text();
                    var number = currentRow.find("td:eq(3)").text();

                    $('.first_name').val(firstname);
                    $('.last_name').val(lastname);
                    $('.email').val(email);
                    $('.number').val(number);
                    $('.editagentid').val(rowid);

                    $('#editagentModal').modal('show');
                }
                else{
                    $('.deleteagentid').val(rowid);
                    $('#deleteagentModal').modal('show');
                }

            }

        );
    });

</script>
<?php /**PATH D:\xampp\htdocs\staffshaw_crm\resources\views/pages/agents.blade.php ENDPATH**/ ?>